--[[ 
 ==================================--
  AzazelMG by CoreLogic 2015
 =================================--
  
   Your own personal AzazelMG, from X-Men First Class. He will lift and drop all peds.   
 
   This code is free to use and share, but please give credit and use in good will. (CoreLogic http://www.developer-me.com/forums/member.php?action=profile&uid=29)
  
   Github: https://github.com/adestefa/AzazelMG.git	
  
  Installation:
	1. Install Script Hook https://www.gta5-mods.com/tools/script-hook-v 
	2. Install the LUA script plugin for Scripthook https://www.gta5-mods.com/tools/lua-plugin-for-script-hook-v 
	3. Download the flatsMiniGame file
	4. Put the <b>AzazelMG.lua</b> file in your <install dir>\Grand Theft Auto V\scripts\addins folder. 
	5. Text will appear above the mini-map when installed correctly
 
 -------------------------------
 version 0.7 7/17/2015
  - base version  
]]--
local AzazelMG = {};
local run = true;
local gameOn = false;
local round = 1;
local timer = 0;
local timer_round = 0;
local limit_round = 1000;
local score_round = {};
local grandTotalLifted = 0;
local mostLiftedAtOnce = 0;
local thisLift = 0;
local score = 0;
local game_score = 0;
local setup = false;        
local pickup_money = GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE");   
local newRecordReached = false;
local seenPeds = {};
local targetAquired = false;
local heightIncrement = 1; --  higher number faster ped moves up when key pressed (and harder to see)
local activatekey = 32;    -- 'Space bar' Activation key change at will
function AzazelMG.reset()
	setup = false;
	newRecordReached = false;
	seenPeds = {};
	for i=1,#seenPeds do
	 seenPeds[i] = nil;
	end
	timer = 0;
	timer_round = 0;
end 
-- =================== --
-- draw text to screen
-- =================== --
function AzazelMG.draw_text(text, x, y, scale)
	UI.SET_TEXT_FONT(0);
	UI.SET_TEXT_SCALE(scale, scale);
	UI.SET_TEXT_COLOUR(255, 255, 255, 255);
	UI.SET_TEXT_WRAP(0.0, 1.0);
	UI.SET_TEXT_CENTRE(false);
	UI.SET_TEXT_DROPSHADOW(2, 2, 0, 0, 0);
	UI.SET_TEXT_EDGE(1, 0, 0, 0, 205);
	UI._SET_TEXT_ENTRY("STRING");
	UI._ADD_TEXT_COMPONENT_STRING(text);
	UI._DRAW_TEXT(y, x);
end
-- ========================== --
-- extra message display area
-- ========================== --
function AzazelMG.displayHitText(txt)
	AzazelMG.draw_text(txt, 0.5, 0.0005, 0.3);
end
function AzazelMG.set()
	local player = PLAYER.PLAYER_PED_ID(); 
	local skin_hash = GAMEPLAY.GET_HASH_KEY("a_f_y_hipster_02");
	STREAMING.REQUEST_MODEL(skin_hash);
	PLAYER.SET_PLAYER_MODEL(player, GAMEPLAY.GET_HASH_KEY("a_f_y_hipster_02"));
	ENTITY.SET_ENTITY_COORDS(player, 1204.983, -2541.552, 37.900, true, true, true, true);
	ENTITY.SET_ENTITY_MAX_SPEED(player, 500);
	ENTITY.SET_ENTITY_INVINCIBLE(player, true);
	ENTITY.SET_ENTITY_HEALTH(player, 200);
	PLAYER.CLEAR_PLAYER_WANTED_LEVEL(player);
	ENTITY.SET_ENTITY_INVINCIBLE(player, false);
	PED.SET_PED_ARMOUR(player, 100);
	setup = true; -- remember if we set the player up
end
-- =============== --
-- Give player cash
-- =============== --
function AzazelMG.giveMoney(amount)
  local playerPosition = ENTITY.GET_ENTITY_COORDS(PLAYER.PLAYER_PED_ID(), false);
  OBJECT.CREATE_AMBIENT_PICKUP(pickup_money, playerPosition.x, playerPosition.y, playerPosition.z, 0, amount, 1, false, true);
end
-- ================================= --
-- Returns if we lifted this Ped
-- ================================= --
function AzazelMG.isNewPed(ped) 
	for i=1,#seenPeds do
	--local thisPedHealth = ENTITY.GET_ENTITY_HEALTH(seenPeds[i]);
	local dead = PED._IS_PED_DEAD(seenPeds[i], true);
		--if(thisPedHealth > 0) then
		if(not dead) then
			if(seenPeds[i] == ped) then
			return false;
			end  
		end
	end
	return true;
end
-- ================================== --
-- Give AzazelMG a new target to lift
-- ================================== --
function AzazelMG.newTarget(ped)
	if (AzazelMG.isNewPed(ped)) then
		table.insert(seenPeds,ped);
		--AzazelMG.giveMoney(1);
		return false;
	else
		return true;
	end   

end
-- ======================================= --
-- print Ped data to console for debugging
-- ======================================= --
function AzazelMG.printPedData()
	--for k,v in ipairs(seenFlats) do
		--print(k,v);
	--end
	for i=1,#seenPeds do
	  print(i,seenPeds[i]);
	end
	AzazelMG.displayHitText("Ped data printed to console");
end
-- ======================================= --
-- print scores per round
-- ======================================= --
function AzazelMG.printScores()
	for i=1,#score_round do
	  print(i,score_round[i]);
	end
	AzazelMG.displayHitText("Score data printed to console");
	wait(1000);
end
-- ===================== --
-- rule set for scoring
-- ===================== --
function AzazelMG.calculateScore()
	-- track score as # of lifted peds
	score = #seenPeds;
	
	-- let us now calculate the points for the game
	-- using total peds lifted 'score' value 
	local bonus = score / 10;
	local points = score * 7;
	local totalpts = math.floor(((bonus*50) + points));
	game_score = totalpts;
	-- draw a progress line (of death)
	AzazelMG.drawASCIILine();
end

function finalScore()
	-- save each round's final score (# of peds lifted) in 'score_round' table
	local tmp_scores = 0;
	if (#score_round > 0) then
		for i=1,#score_round do 
			tmp_scores = tmp_scores + score_round[i];
		end
		-- if we had previous rounds, add their scores to running total
		score = score + tmp_scores;
	end
	
	-- let us now calculate the points for the game
	-- using total peds lifted 'score' value 
	local bonus = score / 10;
	local points = score * 7;
	local totalpts = math.floor(((bonus*50) + points));
	return totalpts;

end
-- ========================================= --
-- draw a line showing number of peds lifted
-- ========================================= --
function AzazelMG.drawASCIILine()
	local ln = "";
	for i=1,#seenPeds do
	  ln = ln .. "|";
	end
	ln = "Round [" .. round .. "] Lifted: " .. #seenPeds .. " " .. ln;
	AzazelMG.draw_text(ln, 0.0, 0.04, 0.4);
	
end
-- ============================================== --
-- play a sound 
-- (where do we find a list of game sound hashes??)
-- ============================================== --
function AzazelMG.playSound()
	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true);
end
-- ================================= --
-- Round is over, rewards and reset
-- ================================= --
function AzazelMG.roundOver()
	--print("roundOver running..");
	run = false;
	local total = #seenPeds * 10;
	local rtotal = 0;
	for i=1,#seenPeds do
		AzazelMG.giveMoney(10);
		AzazelMG.playSound();
		rtotal = rtotal + 10;
		AzazelMG.draw_text("$"..rtotal, 0.4, 0.4, 2.0);
		wait(110);
	end
	round = round + 1;
end
function AzazelMG.force()
	local playerPed = PLAYER.PLAYER_PED_ID();
	local PedTab,PedCount = PED.GET_PED_NEARBY_PEDS(playerPed, 1, -1);
	for k,p in ipairs(PedTab)do 
		if(p == playerPed)then
			else
			
				if (AzazelMG.newTarget(p)) then
					--AzazelMG.playSound();
					-- simply find current ped location
					local coord=ENTITY.GET_ENTITY_COORDS(p,true)
					-- offset z-axis by incrementing palue
					local dz= coord.z + heightIncrement;
					-- lift ped up and set some other configs
					ENTITY.SET_ENTITY_COORDS(p, coord.x, coord.y, dz, true, true, true, true);
					PED.SET_PED_TO_RAGDOLL(p, 6, 20, 20, true, true, true);
					PED.SET_PED_RAGDOLL_ON_COLLISION(p,true);
					PED.SET_PED_RAGDOLL_FORCE_FALL(p);	
					ENTITY.FREEZE_ENTITY_POSITION(p, false);					
					--liftCount = liftCount + 1;
				else
					-- do nothing /not targeting
				end
							
			
						
		end
	end
end
-- ============ --
-- Do the work!
-- ============ --
function AzazelMG.tick()
	local playerPed = PLAYER.PLAYER_PED_ID();
	-- =========================== --
	--   debug print ped data 'p'
	-- =========================== --
	if(get_key_pressed(80)) then --p key	
		AzazelMG.printPedData();
		wait(2500);
	end	
	-- ============================== --
	--   debug force round over 'del'
	-- ============================== --
	if(get_key_pressed(46)) then --del key	
		AzazelMG.roundOver();
		wait(1500);
	end	
	-- ============================= --
	--  debug print table 'pageUp'
	-- ============================= --
	if(get_key_pressed(33)) then --pageUP key	
		AzazelMG.printScores()
		wait(1500);
	end	
	-- ============================= --
	--  AzazelMG stand-alone force 'k'
	-- ============================= --
	if(get_key_pressed(75)) then --k key	
		if (not gameOn) then
			AzazelMG.force();
		end
	end		
	-- =============================== --
	--  toggle 'run' state with F8 key
	-- =============================== --
	if(get_key_pressed(119)) then --# F8 key
		if gameOn then
		   gameOn = false;
		   AzazelMG.finalSoore();
		   AzazelMG.reset();
		else
		   gameOn = true;
		   round_timer = limit_round;
		   seenPeds = {}
		   AzazelMG.roundOver();
		end
		wait(1000)
	end
	-- ============== --
	--  *User Switch
	-- ============== --
	if (gameOn) then
		
 		-- ============= --
		--  Initialize
		-- ============= --
		if (not setup) then
			AzazelMG.set();
		end	
		-- =================================================== --
		--   ped radar, shows highlight when new record count
		-- =================================================== --
		local PedTab,PedCount = PED.GET_PED_NEARBY_PEDS(playerPed, 1, -1);
		if (PedCount > mostLiftedAtOnce) then
			targetAquired = true;
			AzazelMG.draw_text("Ped Radar: [ "..PedCount.." ]", 0.92, 0.4, 0.49);
		else
			targetAquired = false;
			AzazelMG.draw_text("Ped Radar: ("..PedCount..")", 0.92, 0.4, 0.4);
		end
		-- =================== --
		--  simple display UI
		-- =================== --		
		AzazelMG.draw_text(" AzazelMG Mini-Game(v0.7)", 0.68, 0.0005, 0.3);
		AzazelMG.draw_text(" ---------------------------------", 0.7, 0.0005, 0.3);
		AzazelMG.draw_text("  'Space' to summon AzazelMG", 0.72, 0.0005, 0.3);
		AzazelMG.draw_text("  'F8' to end", 0.74, 0.0005, 0.3);
		AzazelMG.draw_text("  Most lifted:"..mostLiftedAtOnce, 0.76, 0.0005, 0.3);
		AzazelMG.draw_text("  Points:"..game_score, 0.78, 0.0005, 0.3);
		-- ============== --		
		--  *Round Switch
		-- ============== --
		if (run) then
			-- =================== --
			--  Round timer check
			-- =================== --
			if (timer_round < limit_round) then
				-- =============== --
				--   loop Peds
				-- =============== --
				local liftCount = 0;
				-- AzazelMG will grab all peds at once!
				for k,p in ipairs(PedTab)do 
					if(p == playerPed)then
					 -- ## LIFT THEM! ##
					else
						-- =================================== --
						-- Emma Frost Whistle... 'Space bar'
						-- =================================== --
						if(get_key_pressed(32)) then -- space bar!
							--  target next ped (not dead)
							if (AzazelMG.newTarget(p)) then
								AzazelMG.playSound();
								-- simply find current ped location
								local coord=ENTITY.GET_ENTITY_COORDS(p,true)
								-- offset z-axis by incrementing palue
								local dz= coord.z + heightIncrement;
								-- lift ped up and set some other configs
								ENTITY.SET_ENTITY_COORDS(p, coord.x, coord.y, dz, true, true, true, true);
								PED.SET_PED_TO_RAGDOLL(p, 6, 20, 20, true, true, true);
								PED.SET_PED_RAGDOLL_ON_COLLISION(p,true);
								PED.SET_PED_RAGDOLL_FORCE_FALL(p);	
								ENTITY.FREEZE_ENTITY_POSITION(p, false);					
								liftCount = liftCount + 1;
								--AzazelMG.draw_text("AzazelMG - Lifting:"..liftCount, 0.4, 0.0005, 0.3);
							else
								-- do nothing /not targeting
							end
							
						end
						
					end
				end
			thisLift = liftCount;
			grandTotalLifted = grandTotalLifted + liftCount;
			-- ============= --	
			--  Most lifted
			-- ============= --	
			if (liftCount > mostLiftedAtOnce) then
				mostLiftedAtOnce = liftCount;
					--newRecordReached = true;
					--AzazelMG.draw_text("AzazelMG - New record:"..mostLiftedAtOnce, 0.4, 0.0005, 0.3);
			end
			--if (newRecordReached) then
				--AzazelMG.draw_text("AzazelMG - New record:"..mostLiftedAtOnce, 0.4, 0.0005, 0.3);
			--end
		
			-- ========--	
			--   score
			-- ======== --	
			AzazelMG.calculateScore();
			AzazelMG.draw_text("  Killed:"..score, 0.8, 0.0005, 0.3);
			
			-- ==================== --	
			-- tick the round timer
			-- ==================== --	
			timer_round = timer_round + 1;
			-- it is better to show countdown to user
			-- so let's reverse the count for display
			local t_tmp = timer_round;
			t_tmp = limit_round - t_tmp;
			-- show the countdown time
			AzazelMG.draw_text("Time left:"..t_tmp, 0.4, 0.0005, 0.4);
			
			-- ================= --	
			--   Round is over
			-- ================= --	
			elseif (timer_round >= limit_round) then
				run = false;
				-- give reward and reset round
				AzazelMG.roundOver();
				timer_round = 0;
			end
		
		-- =============== --	
		--  'run' is false
		-- =============== --	
		else
			
			-- ====================================== --
			--  Round is over, start cool-down timer
			-- ====================================== --
			if (timer < 260) then
				AzazelMG.draw_text(timer, 0.0, 0.04, 0.3);
				AzazelMG.draw_text("  Kills:"..score, 0.8, 0.0005, 0.3);
				local total = #seenPeds * 10;
				AzazelMG.draw_text("Total: $"..total, 0.4, 0.4, 0.8);
				timer = timer + 1;
				-- in the round total cool-down timer, break the time down to display diff msgs
				if (timer < 200) then
					AzazelMG.draw_text("Get Ready...", 0.5, 0.4, 0.7);
				else 
					AzazelMG.draw_text("GO!...", 0.5, 0.4, 0.9);
				end
			
			-- ============================== --	
			-- round cool-down timer is done 
			-- reset and start new round
			-- ============================== --	
			else
				AzazelMG.printPedData();
				-- recalculate score and save to table
				AzazelMG.calculateScore();
				table.insert(score_round,score);
				-- reset and let's go again
				seenPeds = {}
				grandTotalLifted = 0;
				timer = 0;
				run = true;
				
			end
		end
	
	-- ============================================================== --
	-- show game UI display above mini-map telling user how to start
	-- ============================================================== --
	else 
		AzazelMG.draw_text("[K] AzazelMG force v0.8", 0.78, 0.0005, 0.3);
		AzazelMG.draw_text("[F8] To start mini-game", 0.8, 0.0005, 0.3);
	end
	
	
end

function AzazelMG.unload()
end

return AzazelMG